CREATE OR REPLACE FUNCTION alterView() 
RETURNS VOID AS 
$BODY$ 
DECLARE
	msgFinal text := 'CRIADA';
BEGIN 

/*
=======================================================================================
'Nível Classificação.: INFORMAÇÃO RESTRITA
'Versão..............: 20231026
'Job.................:  
'Nome................: v_est_prod_tbl_desc_tipos 
'Objetivo............: 
'Tabelas.............: 
'Dt Criação..........: 
'Criado por..........: 
'Dt Ult Alteracão....: 26/10/2023
'Revisado por........: Marcos Barros
'Alterado por........: Gerson Reis

'=======================================================================================

*/


	CREATE OR REPLACE VIEW public.v_est_prod_tbl_desc_tipos
	AS SELECT 1 AS cd_emp,
    est_prod_preco_desc_prg_prc_filial.cd_filial,
    est_prod_preco_desc_prg.cd_preco_prg AS cd_tbl_desc,
    est_prod_preco_desc_prg.nm_programacao AS ds_tbl_desc,
    est_prod_preco_desc_prg.dt_ini,
    est_prod_preco_desc_prg.dt_vencto AS dt_fim,
    0 AS cd_tp_desconto,
    'desconto programado - antigo'::text AS ds_tp_desconto,
    1 AS sts_tbl_desc,
    est_prod_preco_desc_prg_cpl.cd_prod,
    'est_prod_preco_desc_prg'::text AS ds_hierarquia,
    est_prod_preco_desc_prg_cpl.perc_desc,
    0 AS perc_max,
    0 AS sobrepor_oferta,
    0 AS preco_especifico,
    1 AS tp_desconto,
    0 AS flag_envio_propz,
    0 AS flag_tp_desconto_propz,
    0 AS qtde_pague,
  	0 AS qtde_leve,
  	0 as qtde_acima 
    
   FROM est_prod_preco_desc_prg
     JOIN est_prod_preco_desc_prg_cpl ON est_prod_preco_desc_prg.cd_preco_prg = est_prod_preco_desc_prg_cpl.cd_preco_prg
     JOIN est_prod_preco_desc_prg_prc_filial ON est_prod_preco_desc_prg.cd_preco_prg = est_prod_preco_desc_prg_prc_filial.cd_preco_prg
  WHERE est_prod_preco_desc_prg.dt_vencto >= 'now'::text::date AND est_prod_preco_desc_prg.dt_ini <= 'now'::text::date
UNION ALL
 SELECT est_prod.cd_emp,
    prc_filial.cd_filial,
    0 AS cd_tbl_desc,
    'desconto cadastro produto'::bpchar AS ds_tbl_desc,
    NULL::timestamp without time zone AS dt_ini,
    NULL::timestamp without time zone AS dt_fim,
    0 AS cd_tp_desconto,
    'desconto cadastro produto'::text AS ds_tp_desconto,
    1 AS sts_tbl_desc,
    est_prod.cd_prod,
    'est_prod'::text AS ds_hierarquia,
    est_prod.perc_desc,
    est_prod.perc_desc_limite AS perc_max,
    0 AS sobrepor_oferta,
    0 AS preco_especifico,
    1 AS tp_desconto,
    0 AS flag_envio_propz,
    0 AS flag_tp_desconto_propz,
    0 AS qtde_pague,
  	0 AS qtde_leve,
  	0 as qtde_acima 
   FROM est_prod
     JOIN prc_filial ON est_prod.cd_emp = prc_filial.cd_emp
  WHERE est_prod.perc_desc > 0::numeric
UNION ALL
 SELECT est_prod_preco.cd_emp,
    est_prod_preco.cd_filial,
    0 AS cd_tbl_desc,
    'desconto oferta aplicado'::bpchar AS ds_tbl_desc,
    NULL::timestamp without time zone AS dt_ini,
    NULL::timestamp without time zone AS dt_fim,
    0 AS cd_tp_desconto,
    'desconto oferta aplicado'::text AS ds_tp_desconto,
    1 AS sts_tbl_desc,
    est_prod_preco.cd_prod,
    'est_prod_preco'::text AS ds_hierarquia,
    est_prod_preco.vlr_oferta AS perc_desc,
    0 AS perc_max,
    0 AS sobrepor_oferta,
    0 AS preco_especifico,
    1 AS tp_desconto,
    0 AS flag_envio_propz,
    0 AS flag_tp_desconto_propz,
    0 AS qtde_pague,
  	0 AS qtde_leve,
  	0 as qtde_acima
   FROM est_prod_preco
  WHERE est_prod_preco.vlr_oferta > 0::numeric
UNION ALL
 SELECT est_prod_cpl.cd_emp,
    est_prod_cpl.cd_filial,
    0 AS cd_tbl_desc,
    'desconto fidelidade filial'::bpchar AS ds_tbl_desc,
    NULL::timestamp without time zone AS dt_ini,
    NULL::timestamp without time zone AS dt_fim,
    0 AS cd_tp_desconto,
    'est_prod_cpl'::text AS ds_tp_desconto,
    1 AS sts_tbl_desc,
    est_prod_cpl.cd_prod,
    'est_prod_cpl'::text AS ds_hierarquia,
    0 AS perc_desc,
    est_prod_cpl.perc_desc_limite AS perc_max,
    0 AS sobrepor_oferta,
    0 AS preco_especifico,
    1 AS tp_desconto,
    0 AS flag_envio_propz,
    0 AS flag_tp_desconto_propz,
    0 AS qtde_pague,
  	0 AS qtde_leve,
  	0 as qtde_acima
   FROM est_prod_cpl
  WHERE est_prod_cpl.perc_desc_limite > 0::numeric
UNION ALL
 SELECT est_prod_preco_desc_clas_cliente_prc_filial.cd_emp,
    est_prod_preco_desc_clas_cliente_prc_filial.cd_filial,
    est_prod_preco_desc_clas_cliente.cd_preco_clas_cliente AS cd_tbl_desc,
    est_prod_preco_desc_clas_cliente.ds_preco_clas_cliente AS ds_tbl_desc,
    NULL::timestamp without time zone AS dt_ini,
    NULL::timestamp without time zone AS dt_fim,
    0 AS cd_tp_desconto,
    'desconto por classificacao cliente'::text AS ds_tp_desconto,
    1 AS sts_tbl_desc,
    est_prod_preco_desc_clas_cliente_cpl.cd_prod,
    'est_prod_preco_desc_clas_cliente'::text AS ds_hierarquia,
    est_prod_preco_desc_clas_cliente_cpl.perc_desc,
    est_prod_preco_desc_clas_cliente_cpl.perc_desc_max AS perc_max,
    0 AS sobrepor_oferta,
    0 AS preco_especifico,
    1 AS tp_desconto,
    0 AS flag_envio_propz,
    0 AS flag_tp_desconto_propz,
    0 AS qtde_pague,
  	0 AS qtde_leve,
  	0 as qtde_acima
   FROM est_prod_preco_desc_clas_cliente
     JOIN est_prod_preco_desc_clas_cliente_cpl ON est_prod_preco_desc_clas_cliente.cd_preco_clas_cliente = est_prod_preco_desc_clas_cliente_cpl.cd_preco_clas_cliente
     JOIN est_prod_preco_desc_clas_cliente_prc_filial ON est_prod_preco_desc_clas_cliente.cd_preco_clas_cliente = est_prod_preco_desc_clas_cliente_prc_filial.cd_preco_clas_cliente
UNION ALL
 SELECT rs.cd_emp,
    est_prod_tbl_desc_prc_filial.cd_filial,
    rs.cd_tbl_desc,
    rs.ds_tbl_desc,
    rs.dt_ini,
    rs.dt_fim,
    rs.cd_tp_desconto,
    glb_tp_desconto.ds_tp_desconto,
    rs.sts_tbl_desc,
    rs.cd_prod,
    rs.ds_hierarquia,
    rs.perc_desc,
    rs.perc_desc_max AS perc_max,
    rs.sobrepor_oferta,
    rs.preco_especifico,
    rs.tp_desconto,
    rs.flag_envio_propz,
    rs.flag_tp_desconto_propz,
     rs.qtde_pague,
  	rs.qtde_leve,
  	rs.qtde_acima
   FROM ( SELECT d.cd_emp,
            d.cd_tbl_desc,
            d.ds_tbl_desc,
            d.dt_ini,
            d.dt_fim,
            d.cd_tp_desconto,
            d.sts_tbl_desc,
            a.cd_prod,
            'linha'::text AS ds_hierarquia,
                CASE
                    WHEN l.perc_desc_limite > 0::double precision THEN l.perc_desc_limite
                    ELSE l.perc_desc
                END AS perc_desc,
            l.perc_desc_max,
            0 AS sobrepor_oferta,
            0 AS preco_especifico,
            2 AS tp_desconto,
            d.flag_envio_propz,
            d.flag_tp_desconto_propz,
		    0 AS qtde_pague,
		  	0 AS qtde_leve,
		  	case when ac.qtde_acima is null then 0 else ac.qtde_acima end as qtde_acima
           FROM est_prod_tbl_desc d
             JOIN est_prod_tbl_desc_est_arv_merc_linha l ON d.cd_emp = l.cd_emp AND d.cd_tbl_desc = l.cd_tbl_desc
             JOIN est_prod_est_arv_mercadologica a ON l.cd_emp = a.cd_emp AND l.cd_arv_merc_linha = a.cd_arv_merc_linha
             left join  EST_PROD_TBL_DESC_QTDE_ACIMA ac on d.cd_emp = ac.cd_emp and  d.cd_tbl_desc = ac.cd_tbl_desc
          WHERE d.dt_ini <= 'now'::text::date AND d.dt_fim >= 'now'::text::date
        UNION ALL
         SELECT d.cd_emp,
            d.cd_tbl_desc,
            d.ds_tbl_desc,
            d.dt_ini,
            d.dt_fim,
            d.cd_tp_desconto,
            d.sts_tbl_desc,
            a.cd_prod,
            'categoria'::text AS ds_hierarquia,
                CASE
                    WHEN c.perc_desc_limite > 0::double precision THEN c.perc_desc_limite
                    ELSE c.perc_desc
                END AS perc_desc,
            c.perc_desc_max,
            0 AS sobrepor_oferta,
            0 AS preco_especifico,
            2 AS tp_desconto,
            d.flag_envio_propz,
            d.flag_tp_desconto_propz,
		    0 AS qtde_pague,
		  	0 AS qtde_leve,
		  	case when ac.qtde_acima is null then 0 else ac.qtde_acima end as qtde_acima
           FROM est_prod_tbl_desc d
             JOIN est_prod_tbl_desc_est_arv_merc_categoria c ON d.cd_emp = c.cd_emp AND d.cd_tbl_desc = c.cd_tbl_desc
             JOIN est_prod_est_arv_mercadologica a ON c.cd_emp = a.cd_emp AND c.cd_arv_merc_categ = a.cd_arv_merc_categ
             left join  EST_PROD_TBL_DESC_QTDE_ACIMA ac on d.cd_emp = ac.cd_emp and  d.cd_tbl_desc = ac.cd_tbl_desc
          WHERE d.dt_ini <= 'now'::text::date AND d.dt_fim >= 'now'::text::date
        UNION ALL
         SELECT d.cd_emp,
            d.cd_tbl_desc,
            d.ds_tbl_desc,
            d.dt_ini,
            d.dt_fim,
            d.cd_tp_desconto,
            d.sts_tbl_desc,
            p.cd_prod,
            'fabricante'::text AS ds_hierarquia,
                CASE
                    WHEN f.perc_desc_limite > 0::double precision THEN f.perc_desc_limite
                    ELSE f.perc_desc
                END AS perc_desc,
            f.perc_desc_max,
            0 AS sobrepor_oferta,
            0 AS preco_especifico,
            2 AS tp_desconto,
            d.flag_envio_propz,
            d.flag_tp_desconto_propz,
		    0 AS qtde_pague,
		  	0 AS qtde_leve,
		  	case when ac.qtde_acima is null then 0 else ac.qtde_acima end as qtde_acima
           FROM est_prod_tbl_desc d
             JOIN est_prod_tbl_desc_est_prod_fabric f ON d.cd_emp = f.cd_emp AND d.cd_tbl_desc = f.cd_tbl_desc
             JOIN est_prod p ON f.cd_emp::numeric = p.cd_emp AND f.cd_fabric = p.cd_fabric
             left join  EST_PROD_TBL_DESC_QTDE_ACIMA ac on d.cd_emp = ac.cd_emp and  d.cd_tbl_desc = ac.cd_tbl_desc
          WHERE d.dt_ini <= 'now'::text::date AND d.dt_fim >= 'now'::text::date
        UNION ALL
         SELECT d.cd_emp,
            d.cd_tbl_desc,
            d.ds_tbl_desc,
            d.dt_ini,
            d.dt_fim,
            d.cd_tp_desconto,
            d.sts_tbl_desc,
            p.cd_prod,
            'marca'::text AS ds_hierarquia,
                CASE
                    WHEN m.perc_desc_limite > 0::double precision THEN m.perc_desc_limite
                    ELSE m.perc_desc
                END AS perc_desc,
            m.perc_desc_max,
            0 AS sobrepor_oferta,
            0 AS preco_especifico,
            2 AS tp_desconto,
            d.flag_envio_propz,
            d.flag_tp_desconto_propz,
		    0 AS qtde_pague,
		  	0 AS qtde_leve,
		  	case when ac.qtde_acima is null then 0 else ac.qtde_acima end as qtde_acima
           FROM est_prod_tbl_desc d
             JOIN est_prod_tbl_desc_est_mc m ON d.cd_emp = m.cd_emp AND d.cd_tbl_desc = m.cd_tbl_desc
             JOIN est_prod p ON m.cd_emp::numeric = p.cd_emp AND m.cd_mc = p.cd_mc
             left join  EST_PROD_TBL_DESC_QTDE_ACIMA ac on d.cd_emp = ac.cd_emp and  d.cd_tbl_desc = ac.cd_tbl_desc
          WHERE d.dt_ini <= 'now'::text::date AND d.dt_fim >= 'now'::text::date
        UNION ALL
         SELECT d.cd_emp,
            d.cd_tbl_desc,
            d.ds_tbl_desc,
            d.dt_ini,
            d.dt_fim,
            d.cd_tp_desconto,
            d.sts_tbl_desc,
            a.cd_prod,
            'familia'::text AS ds_hierarquia,
                CASE
                    WHEN e.perc_desc_limite > 0::double precision THEN e.perc_desc_limite
                    ELSE e.perc_desc
                END AS perc_desc,
            e.perc_desc_max,
            0 AS sobrepor_oferta,
            0 AS preco_especifico,
            2 AS tp_desconto,
            d.flag_envio_propz,
            d.flag_tp_desconto_propz,
		    0 AS qtde_pague,
		  	0 AS qtde_leve,
		  	case when ac.qtde_acima is null then 0 else ac.qtde_acima end as qtde_acima
           FROM est_prod_tbl_desc d
             JOIN est_prod_tbl_desc_est_arv_merc_familia e ON d.cd_emp = e.cd_emp AND d.cd_tbl_desc = e.cd_tbl_desc
             JOIN est_prod_est_arv_mercadologica a ON e.cd_emp = a.cd_emp AND e.cd_arv_merc_familia = a.cd_arv_merc_familia
             left join  EST_PROD_TBL_DESC_QTDE_ACIMA ac on d.cd_emp = ac.cd_emp and  d.cd_tbl_desc = ac.cd_tbl_desc
          WHERE d.dt_ini <= 'now'::text::date AND d.dt_fim >= 'now'::text::date
        UNION ALL
         SELECT d.cd_emp,
            d.cd_tbl_desc,
            d.ds_tbl_desc,
            d.dt_ini,
            d.dt_fim,
            d.cd_tp_desconto,
            d.sts_tbl_desc,
            t.cd_prod,
            'produto'::text AS ds_hierarquia,
                CASE
                    WHEN t.perc_desc_limite > 0::double precision THEN t.perc_desc_limite
                    ELSE t.perc_desc
                END AS perc_desc,
            t.perc_desc_max,
            0 AS sobrepor_oferta,
            0 AS preco_especifico,
            2 AS tp_desconto,
            d.flag_envio_propz,
            d.flag_tp_desconto_propz,
		    0 AS qtde_pague,
		  	0 AS qtde_leve,
		  	case when ac.qtde_acima is null then 0 else ac.qtde_acima end as qtde_acima 
           FROM est_prod_tbl_desc d
             JOIN est_prod_tbl_desc_est_prod t ON d.cd_emp = t.cd_emp AND d.cd_tbl_desc = t.cd_tbl_desc
             left join  EST_PROD_TBL_DESC_QTDE_ACIMA ac on d.cd_emp = ac.cd_emp and  d.cd_tbl_desc = ac.cd_tbl_desc
          WHERE d.dt_ini <= 'now'::text::date AND d.dt_fim >= 'now'::text::date) rs
     JOIN est_prod_tbl_desc_prc_filial ON rs.cd_emp = est_prod_tbl_desc_prc_filial.cd_emp AND rs.cd_tbl_desc = est_prod_tbl_desc_prc_filial.cd_tbl_desc
     JOIN glb_tp_desconto ON rs.cd_tp_desconto = glb_tp_desconto.cd_tp_desconto
UNION ALL
 SELECT qtd.cd_emp,
    qtd.cd_filial,
    qtd.cd_tbl_desc_qtde AS cd_tbl_desc,
    qtd.ds_tbl_desc_qtde AS ds_tbl_desc,
    qtd.dt_ini,
    qtd.dt_fim,
    qtd.cd_tp_desconto,
    qtd.ds_tp_desconto,
    qtd.sts_tbl_desc,
    qtd.cd_prod,
    qtd.ds_hierarquia,
    qtd.perc_desc,
    qtd.perc_desc_max AS perc_max,
    qtd.sobrepor_oferta,
    qtd.preco_especifico,
    qtd.tp_desconto,
    qtd.flag_envio_propz,
    qtd.flag_tp_desconto_propz,
    qtd.qtde_pague,
  	qtd.qtde_leve,  
  	0 as qtde_acima
   FROM v_est_prod_tbl_desc_qtde_tipos qtd
  WHERE qtd.sts_tbl_desc = 1 AND qtd.dt_ini <= 'now'::text::date AND qtd.dt_fim >= 'now'::text::date;

  RAISE NOTICE 'Visão v_est_prod_tbl_desc_tipos FOI %', msgFinal::varchar;

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION alterView() OWNER TO postgres; 
SELECT alterView(); 
DROP FUNCTION alterView();
